package de.willemer.minesweeper;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

public class HighscoreSQLHelper extends SQLiteOpenHelper {

    static final int dbversion = 2;
    public HighscoreSQLHelper(Context context) {
        super(context, "highscore.db", null, dbversion);
    }

    static final String TABELLE = "highscore";
    static final String ID = "_id";
    static final String SEKUNDEN = "sekunden";
    static final String DATUM = "datum";
    static final String SPIELERNAME = "spielername";

    @Override
    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        String sqlString = "CREATE TABLE " + TABELLE +
                "(" +
                ID + " INTEGER PRIMARY KEY," +
                SPIELERNAME + " VARCHAR," +
                SEKUNDEN + "  INTEGER," +
                DATUM + " VARCHAR);";
        sqLiteDatabase.execSQL(sqlString);
    }

    @Override
    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldversion, int newversion) {
        if (oldversion != newversion) {
            sqLiteDatabase.execSQL("DROP TABLE IF EXISTS "
                    + TABELLE);
            onCreate(sqLiteDatabase);
        }
    }

    public long insert(String spieler, long sekunden, String datum) {
        long zeile = -1;
        SQLiteDatabase db = getWritableDatabase();
        try {
            ContentValues values = new ContentValues();
            values.put(SPIELERNAME, spieler);
            values.put(SEKUNDEN, sekunden);
            values.put(DATUM, datum);
            zeile = db.insert(TABELLE, null, values);
        } catch (SQLiteException e) {
            Log.e(this.getClass().getSimpleName(), "insert failed");
        } finally {
            db.close();
        }
        return zeile;
    }

    public Cursor query() {
        SQLiteDatabase db = getReadableDatabase();
        return db.query(TABELLE, // Die Tabelle
        null, // Die Spalten, die ausgewählt werden, als String-Array
        null, // Die WHERE-Klausel
        null, // Wenn ? in der WHERE-Klausel stehen, werden sie hier aufgelöst
        null, // Die GROUP BY-Klausel
        null, // Die HAVING-Klausel
        SEKUNDEN+" ASC"); // Die ORDER-BY-Klausel
    }
}
