package de.willemer.minesweeper;

import android.database.Cursor;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

public class HighRecycleAdapter extends RecyclerView.Adapter {

    private Cursor cursor = null;

    public HighRecycleAdapter(Cursor cursor) {
        this.cursor = cursor;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.listelement,
                parent, false);
        RecyclerView.ViewHolder vh = new HighRecycleAdapter.ViewHolder(v);
        return vh;
    }

    @Override
    public int getItemCount() {
        return cursor.getCount();
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        cursor.moveToPosition(position);
        tvSekunden.setText("" + cursor.getInt(cursor.getColumnIndex(HighscoreSQLHelper.SEKUNDEN)));
        tvDatum.setText(cursor.getString(cursor.getColumnIndex(HighscoreSQLHelper.DATUM)));
        tvSpieler.setText(cursor.getString(cursor.getColumnIndex(HighscoreSQLHelper.SPIELERNAME)));

    }

    private TextView tvSekunden, tvDatum, tvSpieler;

    public class ViewHolder extends RecyclerView.ViewHolder {

        public ViewHolder(View v) {
            super(v);
            tvSekunden = (TextView)v.findViewById(R.id.reSekunden);
            tvDatum = (TextView)v.findViewById(R.id.reDatum);
            tvSpieler = (TextView)v.findViewById(R.id.reSpieler);
        }
    }
}
