package de.willemer.minesweeper;

public class Anzeige {

	public static final char TREFFER = 'X';
	public static final char UNGEKLICKT = ' ';
	public static final char MARK = '+';

	private char [][] feld;
	
	public Anzeige(int x, int y) {
		feld = new char[x][y];
        for (int i=0; i<x; i++) {
            for (int j=0; j<y; j++) {
                feld[i][j] = UNGEKLICKT;
            }
        }
	}
	
	public void fuelleFeld(int x, int y, char symbol) {
		feld[x][y] = symbol;
	}

	public char holeFeld(int x, int y) {
		return feld[x][y];
	}

	public int unaufgedeckt() {
		int anzahl = 0;
		for (int x=0; x<feld.length; x++) {
			for (int y=0; y<feld[0].length; y++) {
				if (feld[x][y]==UNGEKLICKT ||
						feld[x][y]==MARK) {
					anzahl++;
				}
			}
		}
		return anzahl;
	}
	
	public void markiere(int x, int y) {
		if (holeFeld(x, y) == MARK) {
			fuelleFeld(x, y, UNGEKLICKT);
		} else {
			fuelleFeld(x, y, MARK);
		}
	}
}
