package de.willemer.lotto;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Button bt = (Button) findViewById(R.id.btNeu);
        bt.setOnClickListener(this);
    }

    @Override
    public void onClick(View view) {
        java.util.Random zufall = new java.util.Random();
        Integer[] lotto = new Integer[6];
        // Erstelle die Lottozahlen ohne Doppelte
        for (int i=0; i<6; i++) {
            lotto[i] = zufall.nextInt(49) + 1;
            // Vergleiche mit vorigen Ziehungen
            for (int k=0; k<i; k++) {
                if (lotto[k]==lotto[i]) {
                    i--; // Doppelt, Ziehung wiederholen!
                }
            }
        }
        java.util.Arrays.sort(lotto); // sortiere die Lottozahlen
        // Übernahme des int-Arrays in ein String-Array
        String[] strListe = new String[lotto.length];
        for (int i=0; i<lotto.length; i++) {
            strListe[i] = "" + lotto[i];
        }
        // Übernehme das String-Array in den Adapter
        ArrayAdapter adapter = new ArrayAdapter(this,
                android.R.layout.simple_list_item_1, strListe);
        ListView listView = (ListView)findViewById(R.id.lvLotto);
        listView.setAdapter(adapter); // übernehme den Adapter
    }
}