package de.willemer.kamera;

import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import android.Manifest;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.Toast;
import android.widget.VideoView;

import java.io.File;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    //private String dateiname = Environment.getExternalStorageDirectory()+"/bild.png";
    private String dateiname = Environment.getExternalStorageDirectory()+"/video.mp4";
    private String[] permissions = {
            Manifest.permission.CAMERA,
            Manifest.permission.READ_EXTERNAL_STORAGE,
            Manifest.permission.WRITE_EXTERNAL_STORAGE};

    ActivityResultLauncher<Intent> rufeKamera = registerForActivityResult(
            new ActivityResultContracts.StartActivityForResult(),
            new ActivityResultCallback<ActivityResult>() {
                @Override
                public void onActivityResult(ActivityResult result) {
                    if (result.getResultCode() == Activity.RESULT_OK) {
//                        Bitmap bm = BitmapFactory.decodeFile(dateiname);
//                        ImageView iv = (ImageView) findViewById(R.id.imageView);
//                        iv.setImageBitmap(bm);
                        MediaController mediaController = new MediaController(MainActivity.this);
                        VideoView vv = (VideoView) findViewById(R.id.videoView);
                        vv.setMediaController(mediaController);
                        vv.setVideoPath(dateiname);
                        vv.start();
                    }
                }
            });

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        if ( ! pruefeRechteLage(permissions)) {
            ActivityCompat.requestPermissions(MainActivity.this,
                    permissions, 123);
        }

        Button bt = (Button) findViewById(R.id.button);
        bt.setOnClickListener(this);
    }

    private boolean pruefeRechteLage(String[] rechte) {
        boolean ok = true;
        for (String recht : rechte) {
            if (ContextCompat.checkSelfPermission(this, recht)
                    !=PackageManager.PERMISSION_GRANTED) {
                ok = false;
            }
        }
        return ok;
    }

    @Override
    public void onClick(View view) {
        File file = new File(dateiname);
        Uri uri = Uri.fromFile(file);
        if (pruefeRechteLage(permissions)) {
            // Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
            Intent intent = new Intent(MediaStore.ACTION_VIDEO_CAPTURE);
            intent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
            rufeKamera.launch(intent);
            // startActivityForResult(intent, 123);
        }
    }

}