package de.willemer.gpspermission;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import android.Manifest;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;

public class MainActivity extends AppCompatActivity
        implements LocationListener {
    private static final String TAG = "GpsPermission";
    private LocationManager locationManager;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        locationManager = (LocationManager) this.getSystemService(LOCATION_SERVICE);
        // Benutzerdialog, um die Berechtigung zu erfragen
        ActivityCompat.requestPermissions(MainActivity.this,
            new String[] {
              Manifest.permission.ACCESS_FINE_LOCATION},
            123);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
        String permissions[], int[] grantResults) {
        if (requestCode==123) { // meist unnötig
            // Sammle die fehlenden Berechtigungen
            ArrayList<String> fehlendeErlaubnis
                    = new ArrayList<>();
            for (int i = 0; i < grantResults.length; i++) {
                if (grantResults[i]
                        !=PackageManager.PERMISSION_GRANTED) {
                    fehlendeErlaubnis.add(permissions[i]);
                }
            }
            if (fehlendeErlaubnis.size() > 0) {
                Toast.makeText(this, "Ohne GPS sinnlos!",
                        Toast.LENGTH_LONG).show();
                finish();
            }
        } else { // nicht meine Baustelle
            super.onRequestPermissionsResult(requestCode,
                    permissions,grantResults);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        // Darf ich GPS?
        if (ActivityCompat.checkSelfPermission(this,
                Manifest.permission.ACCESS_FINE_LOCATION)
                == PackageManager.PERMISSION_GRANTED)
        {
            locationManager.requestLocationUpdates(
                    LocationManager.GPS_PROVIDER,
                    1000, 10, this); // 1000 ms, 10 m
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        // Darf ich GPS?
        if (ActivityCompat.checkSelfPermission(this,
                Manifest.permission.ACCESS_FINE_LOCATION)
                == PackageManager.PERMISSION_GRANTED)
        {
            locationManager.removeUpdates(this);
        }
    }

    @Override
    public void onLocationChanged(Location location) {
        String str =
            "Long: " + location.getLongitude() +
            "\nLat: " + location.getLatitude() +
            "\nHöhe: " + location.getAltitude() +
            "\nGenauigkeit: " + location.getAccuracy() +
            "\nZeitstempel: " + location.getTime();
        Log.d(TAG, str);
        TextView view = (TextView) findViewById(R.id.txtInfo);
        view.setText(str);
    }
}
