package de.willemer.ersterversuch;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.text.Editable;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        // Anmelden der Button-Ereignisse
        Button button = (Button) findViewById(R.id.button);
        button.setOnClickListener(this);
    }

    @Override
    public void onClick(View view) {
        // Auslesen der Länge aus dem Eingabefeld
        EditText edLaenge = (EditText) findViewById(R.id.edLaenge);
        String strLaenge = edLaenge.getText().toString();
        double laenge = Double.parseDouble(strLaenge);
        // Auslesen der Breite aus dem Eingabefeld
        EditText edBreite = (EditText) findViewById(R.id.edBreite);
        String str = edBreite.getText().toString();
        double breite = Double.parseDouble(str);
        // Die Berechung von Fläche und Umfang
        double flaeche = breite * laenge;
        double umfang = 2 * breite + 2 * laenge;
        // Ausgabe im Logcat
        Log.d("ersterversuch", "Fläche :"+flaeche);
        Log.d(this.getClass().getSimpleName(), "" + flaeche);
        // Ein kleiner Dialog zur Demonstration des Toast
        Toast.makeText(this, "Umfang: "+umfang,
                Toast.LENGTH_LONG).show();
        // Ausgabe in den TextViews
        TextView tvFlaeche =(TextView) findViewById(R.id.tvFlaeche);
        tvFlaeche.setText(""+flaeche);
        TextView tvUmfang =(TextView) findViewById(R.id.tvUmfang);
        tvUmfang.setText(""+umfang);
    }
}