package de.willemer.bmiradio;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity
        implements View.OnClickListener,
        View.OnFocusChangeListener,
        CompoundButton.OnCheckedChangeListener,
        RadioGroup.OnCheckedChangeListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        // ---------- melde die Listener an --------------
        // den Button für Click
        Button button=(Button)findViewById(R.id.btBerechne);
        button.setOnClickListener(this);
        // die Eingabefelder für Fokus
        EditText edGro  = (EditText) findViewById(R.id.edGroesse);
        edGro.setOnFocusChangeListener(this);
        EditText edGew  = (EditText) findViewById(R.id.edGewicht);
        edGew.setOnFocusChangeListener(this);
        // Hakenwechsel bei CheckBox
        CheckBox cb = (CheckBox) findViewById(R.id.cbWeiblich);
        cb.setOnCheckedChangeListener(this);
        // Wechsel innerhalb der RadioGroup
        RadioGroup rg = (RadioGroup)findViewById(R.id.rgAlter);
        rg.setOnCheckedChangeListener(this);
    }

    // -------------- Ereignsbehandlungen ---------------------

    @Override
    public void onClick(View view) {
        berechneBMI();
    }

    @Override
    public void onFocusChange(View view, boolean b) {
        berechneBMI();
    }

    @Override
    public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
        berechneBMI();
    }

    @Override
    public void onCheckedChanged(RadioGroup radioGroup, int i) {
        berechneBMI();
    }

    // ---------------------- Erechnung des BMI ---------------------

    private void berechneBMI() {
        int groesse = leseGroesse();
        double gewicht = leseGewicht();
        int bmi = errechneBmiIndex(groesse, gewicht);
        bmi = abschlagGeschlecht(bmi);
        bmi = abschlagAlter(bmi);
        String meldung = indexText(bmi);
        ergebnisAusgabe(meldung, bmi);
    }

    private void ergebnisAusgabe(String meldung, int bmi) {
        TextView tv = (TextView) findViewById(R.id.tvErgebnis);
        tv.setText(meldung+" ("+bmi+")");
    }

    private String indexText(int bmi) {
        String ausgabe = "";
        if (bmi < 10) {
            ausgabe = "nicht überlebensfähig";
        } else if (bmi < 12) {
            ausgabe = "lebensbedrohlich";
        } else if (bmi < 16) {
            ausgabe = "muss stationär behandelt werden";
        } else if (bmi < 19) {
            ausgabe = "Untergewicht";
        } else if (bmi < 25) {
            ausgabe = "Normalgewicht";
        } else if (bmi < 30) {
            ausgabe = "Übergewicht";
        } else if (bmi < 35) {
            ausgabe = "Adipositas Grad I";
        } else if (bmi < 40) {
            ausgabe = "Adipositas Grad II";
        } else {
            ausgabe = "Adipositas Grad III";
        }
        return ausgabe;
    }

    private int abschlagAlter(int bmi) {
        if (((RadioButton) (findViewById(R.id.rb34))).isChecked())
            bmi -= 1;
        else if (((RadioButton) (findViewById(R.id.rb44)))
                .isChecked())
            bmi -= 2;
        else if (((RadioButton) (findViewById(R.id.rb54)))
                .isChecked())
            bmi -= 3;
        else if (((RadioButton) (findViewById(R.id.rb64)))
                .isChecked())
            bmi -= 4;
        else if (((RadioButton) (findViewById(R.id.rb65)))
                .isChecked())
            bmi -= 5;
        return bmi;
    }

    private int abschlagGeschlecht(int bmi) {
        CheckBox cbWeiblich = (CheckBox)
                findViewById(R.id.cbWeiblich);
        if (!cbWeiblich.isChecked()) {
            bmi -= 1;
        }
        return bmi;
    }

    private int errechneBmiIndex(int groesse, double gewicht) {
        double bmi = gewicht / (groesse * groesse * 1E-4);
        return (int)(Math.round(bmi));
    }

    private double leseGewicht() {
        EditText edGewicht = (EditText)
                findViewById(R.id.edGewicht);
        String strGewicht = edGewicht.getText().toString();
        double gewicht = Double.parseDouble(strGewicht);
        return gewicht;
    }

    private int leseGroesse() {
        EditText edGroesse = (EditText)
                findViewById(R.id.edGroesse);
        String strGroesse = edGroesse.getText().toString();
        return Integer.parseInt(strGroesse);
    }
}