package de.willemer.audio;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import android.Manifest;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import java.io.IOException;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    private String[] permissions = {
        Manifest.permission.RECORD_AUDIO,
        Manifest.permission.READ_EXTERNAL_STORAGE,
        Manifest.permission.WRITE_EXTERNAL_STORAGE};

    private String dateiname =
        Environment.getExternalStorageDirectory()+"/record.3gp";

    private boolean pruefeRechteLage(String[] rechte) {
        boolean ok = true;
        for (String recht : rechte) {
            if (ContextCompat.checkSelfPermission(this, recht)
                    != PackageManager.PERMISSION_GRANTED) {
                ok = false;
            }
        }
        return ok;
    }

    MediaRecorder recorder = null;
    MediaPlayer player = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        if ( ! pruefeRechteLage(permissions)) {
            ActivityCompat.requestPermissions(this,
                    permissions, 123);
        }

        Button btrec = (Button) findViewById(R.id.btRecord);
        btrec.setOnClickListener(this);
        btrec.setBackgroundColor(Color.BLUE);
        Button btplay = (Button) findViewById(R.id.btPlay);
        btplay.setOnClickListener(this);
        btplay.setBackgroundColor(Color.BLUE);
    }

    @Override
    public void onClick(View view) {
        if (pruefeRechteLage(permissions)) {
            if (view.getId() == R.id.btRecord) {
                // Für jede Aufnahme einen eigenen MediaRecorder!
                if (recorder==null) { // nur wenn keine Aufnahme läuft
                    recorder = new MediaRecorder();
                    recorder.setAudioSource(MediaRecorder.AudioSource.MIC);
                    recorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
                    recorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
                    recorder.setOutputFile(dateiname);
                    try {
                        recorder.prepare();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    recorder.start();
                    Button bt = (Button)findViewById(R.id.btRecord);
                    bt.setBackgroundColor(Color.RED);
                    bt.setText("Stop!");
                } else { // Aufnahme läuft. Stopp!
                    recorder.stop();
                    recorder.release();
                    recorder = null;
                    Button bt = (Button)findViewById(R.id.btRecord);
                    bt.setBackgroundColor(Color.BLUE);
                    bt.setText("Aufnahme");
                }
            } else if (view.getId() == R.id.btPlay) {
                // Wenn eine Audiodatei aus den Ressourcen gestartet werden soll
                // AssetFileDescriptor afd = this.getResources().openRawResourceFd(ResID);
                if (player==null) {
                    player = new MediaPlayer();
                    player.setAudioAttributes(
                            new AudioAttributes.Builder()
                                    .setContentType(AudioAttributes.CONTENT_TYPE_MUSIC)
                                    .setUsage(AudioAttributes.USAGE_MEDIA)
                                    .build()
                    );
                    player.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
                        @Override
                        public void onCompletion(MediaPlayer mediaPlayer) {
                            player.release();
                            player = null;
                            Button bt = (Button) findViewById(R.id.btPlay);
                            bt.setText("Wiedergabe");
                            bt.setBackgroundColor(Color.BLUE);
                        }
                    });
                    try {
                        player.setDataSource(dateiname);
                        player.prepare();
                        player.start();
                    } catch (IOException e) {
                        Toast.makeText(this, "IO-Fehler beim Abspielen", Toast.LENGTH_LONG).show();
                    }
                    Button bt = (Button) findViewById(R.id.btPlay);
                    bt.setText("Stop");
                    bt.setBackgroundColor(Color.GREEN);
                } else {
                    player.stop();
                    player.release();
                    player = null;
                    Button bt = (Button) findViewById(R.id.btPlay);
                    bt.setText("Wiedergabe");
                    bt.setBackgroundColor(Color.BLUE);

                }
            }
        }
    }
}